// SHAPI_LVC_2012SEP17.h
// Copyright 2012 Test Equipment Plus

//Function headers for SHAPI.dll with SA124 support, including a collection of Labview-Compatible function calls.

//Corresponds to manual version 2012_01_05 except for added Labview functions, which add an LVC for 
// "LabViewCompatible", also 32-bit Matlab compatible


// ****************** LABVIEW COMPATIBLE FUNCTIONS ********************************
// Generally, set deviceNum to 0, unless using multiple devices.
extern "C" __declspec( dllimport ) void SHAPI_LVC_LoadTemperatureCorrections(char * filename, int deviceNum);

extern "C" __declspec( dllimport ) void SHAPI_LVC_SetPreamp(int val, int deviceNum);

extern "C" __declspec( dllimport ) unsigned int SHAPI_LVC_GetSerNum(int deviceNum);

extern "C" __declspec( dllimport ) void SHAPI_LVC_Initialize();

extern "C" __declspec( dllimport ) int SHAPI_LVC_GetSA124CalData(char * filename,int deviceNum); 

extern "C" __declspec( dllimport ) int SHAPI_LVC_Configure(double attenVal, int mixerBand, int sensitivity,  
										   int decimation, int useIF2_9, int ADCclock, int deviceNum);

extern "C" __declspec( dllimport ) int SHAPI_LVC_ConfigureFast(double attenVal, int mixerBand, int sensitivity,  
										   int decimation, int useIF2_9, int ADCclock, int deviceNum);

extern "C" __declspec( dllimport ) int SHAPI_LVC_GetSlowSweepCount(double startFreq, double stopFreq, int FFTSize,int deviceNum);


extern "C" __declspec( dllimport ) int SHAPI_LVC_GetSlowSweep(double * dBArray, double startFreq, double stopFreq,  
										  int * pReturnCount, int FFTSize, 
										  int avgCount, int imageHandling, int deviceNum);

extern "C" __declspec( dllimport ) int SHAPI_LVC_GetFastSweepCount(double startFreq, double stopFreq, int FFTSize);

extern "C" __declspec( dllimport ) int SHAPI_LVC_GetFastSweep(double * dBArray, double startFreq, double stopFreq,  
													  int * pReturnCount, int FFTSize, int imageHandling, int deviceNum);

extern "C" __declspec( dllimport ) int SHAPI_LVC_GetIQDataPacket(int * pIData, int * pQData, double * pCenterFreq, int size, int deviceNum);

extern "C" __declspec( dllimport ) int SHAPI_LVC_SetupLO(double * pCenterFreq, int mixMode, int deviceNum);

extern "C" __declspec( dllimport ) int SHAPI_LVC_StartStreamingData(int deviceNum);

extern "C" __declspec( dllimport ) int SHAPI_LVC_StopStreamingData(int deviceNum);

extern "C" __declspec( dllimport ) int SHAPI_LVC_GetStreamingPacket(int *bufI, int *bufQ, int deviceNum);

extern "C" __declspec( dllimport ) int  SHAPI_LVC_ProcTGSweep(double * dBArray, double startFreq, double stepSize, int count, int attenval);

extern "C" __declspec( dllimport ) int  SHAPI_LVC_SetTGFreqAtten(double freq, unsigned char atten);



// ****************** STANDARD FUNCTIONS ********************************
extern "C" __declspec( dllimport ) int SHAPI_GetSerialNumbers(unsigned int * pSerNumArray); //Returns -1 on error
extern "C" __declspec( dllimport ) void SHAPI_DisableDataPipes();

extern "C" __declspec( dllimport ) float SHAPI_GetTemperature(int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_LoadTemperatureCorrections(LPCSTR filename, int deviceNum=0);
extern "C" __declspec( dllimport ) void SHAPI_SetPreamp(int val, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_IsPreampAvailable(int deviceNum=0);
extern "C" __declspec( dllimport ) double SHAPI_GetFMFFTPK(int deviceNum=0);
extern "C" __declspec( dllimport ) double SHAPI_GetAudioFFTSample(int idx, int deviceNum=0);
extern "C" __declspec( dllimport ) unsigned int SHAPI_GetSerNum(int deviceNum=0);
extern "C" __declspec( dllimport ) void SHAPI_SyncTriggerMode(int mode, int deviceNum=0);
extern "C" __declspec( dllimport ) void SHAPI_CyclePowerOnExit(int deviceNum=0);
extern "C" __declspec( dllimport ) double SHAPI_GetAMFFTPK(int deviceNum=0);
extern "C" __declspec( dllimport ) void SHAPI_ActivateAudioFFT(int deviceNum=0);
extern "C" __declspec( dllimport ) void SHAPI_DeactivateAudioFFT(int deviceNum=0);
extern "C" __declspec( dllimport ) double SHAPI_GetRBW(int FFTSize, int decimation);
extern "C" __declspec( dllimport ) double SHAPI_GetLastChannelPower(int deviceNum=0);
extern "C" __declspec( dllimport ) double SHAPI_GetLastChannelFreq(int deviceNum=0);
extern "C" __declspec( dllimport ) void SHAPI_SetOscRatio(double ratio,int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_InitializeNext(); //Returns -1 on error
extern "C" __declspec( dllimport ) int SHAPI_GetSA124CalData(LPCSTR filename,int deviceNum=0); //Returns -1 on error
extern "C" __declspec( dllimport ) int SHAPI_IsSA124(int deviceNum=0); //Returns -1 on error
extern "C" __declspec( dllimport ) int SHAPI_Initialize();
extern "C" __declspec( dllimport ) void SHAPI_WriteCalTable(unsigned char *myTable, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_CopyCalTable(unsigned char * p4KTable, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_InitializeEx(unsigned char * p4KTable, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_SetAttenuator(double attenVal, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_SelectExt10MHz(int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_Configure(double attenVal=10.0, int mixerBand=1, int sensitivity=0,  
												   int decimation=1, int useIF2_9=0, int ADCclock=0, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_ConfigureFast(double attenVal=10.0, int mixerBand=1, int sensitivity=0,  
												   int decimation=1, int useIF2_9=0, int ADCclock=0, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_GetSlowSweepCount(double startFreq, double stopFreq, int FFTSize,int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_GetSlowSweep(double * dBArray, double startFreq, double stopFreq,  
													  int &returnCount, int FFTSize=1024, 
													  int avgCount=16, int imageHandling=0, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_GetFastSweepCount(double startFreq, double stopFreq, int FFTSize);
extern "C" __declspec( dllimport ) int SHAPI_CyclePort();

extern "C" __declspec( dllimport ) int SHAPI_GetFastSweep(double * dBArray, double startFreq, double stopFreq,  
													  int &returnCount, int FFTSize=16, int imageHandling=0, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_GetIQDataPacket(int * pIData, int * pQData, double &centerFreq, int size, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_Authenticate(int vendorcode=0, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_SetupLO(double &centerFreq, int mixMode=1, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_StartStreamingData(int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_StopStreamingData(int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_GetStreamingPacket(int *bufI, int *bufQ, int deviceNum=0);
extern "C" __declspec( dllimport ) double SHAPI_GetPhaseStep(int deviceNum=0);
extern "C" __declspec( dllimport ) double SHAPI_GetChannelPower(double cf, int *iBigI, int *iBigQ, int count, int deviceNum);
extern "C" __declspec( dllimport ) int SHAPI_GetIntFFT(int FFTSize, int *iBigI, int *iBigQ, double * dFFTOut, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_SetupFastSweepLoop(double startFreq, double stopFreq, int &returnCount, int MaxFFTSize=16, int imageHandling=0, int AvgCount=1, int deviceNum =0);
extern "C" __declspec( dllimport ) int SHAPI_SetupMultiFreqSweepLoop(int count, double * freqbuf, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_GetMultiFreqIQ(int count, int size, int * pI1, int * pQ1, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_SetupMultiBandSweepLoop(int count, double * freqbuf, int * freqsize, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_GetMultiBandIQ(int count, int size, int * pI1, int * pQ1, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_GetFSLoopIQSize(double startFreq, double stopFreq, int MaxFFTSize=16);
extern "C" __declspec( dllimport ) int SHAPI_GetFSLoopIQ(int * pI1, int * pQ1, int * pI2, int * pQ2, double startFreq, double stopFreq, int MaxFFTSize=16, int imageHandling=0, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_ProcessFSLoopData(double * dBArray, int * pI1, int * pQ1, int * pI2, int * pQ2, double startFreq, double stopFreq, 
												int &returnCount, int FFTSize=16,int MaxFFTSize=16, int imageHandling=0, int deviceNum=0);
extern "C" __declspec( dllimport ) int  SHAPI_RunMeasurementReceiver(void * LPStruct, int deviceNum=0);
extern "C" __declspec( dllimport ) int  SHAPI_ProcTGSweep(double * dBArray, double startFreq, double stepSize, int count, int attenval, double TBMultiplier=1.0, int deviceNum=0); // Fill
extern "C" __declspec( dllimport ) int  SHAPI_SetTGFreqAtten(double freq, unsigned char atten); // Fill
extern "C" __declspec( dllimport ) void  SHAPI_TGSyncOff(int deviceNum=0);
extern "C" __declspec( dllimport ) int  SHAPI_BBSPSweep(double * pData, int startfreq, int stopfreq, int stepfreq, int deviceNum=0); //in MHz
extern "C" __declspec( dllimport ) int  SHAPI_ProcessData(double * pAmpData, double * pFreqData, int * pIData, int * pQData, double ctrfreq, int datacount, int fftsz , int deviceNum=0); //in MHz
extern "C" __declspec( dllimport ) int  SHAPI_ProcessLoopPatch(double * pAmpData, double * pFreqData, int * pIDataH, int * pQDataH,int * pIDataL, int * pQDataL, double ctrfreq, int fftsz, 
															   bool rejectImage, int deviceNum=0 ); // max fftsz 256;
extern "C" __declspec( dllimport ) int  SHAPI_BuildIQFIR(double * pReal, double * pImag, int deviceNum=0); // max fftsz 256;
extern "C" __declspec( dllimport ) int  SHAPI_ProcIQ(double freq, double * dIout, double * dQout, int * pI, int * pQ, int * pIold, int * pQold, double * pFIRRe, double * pFIRIm, int deviceNum=0); // max fftsz 256;
extern "C" __declspec( dllimport ) int SHAPI_GetBBPowerReading(double freq, int deviceNum=0);
extern "C" __declspec( dllimport ) void SHAPI_SetEFCDAC(int efcdac, int deviceNum=0);
extern "C" __declspec( dllimport ) void SHAPI_Set36MHzGain(int gain, int deviceNum=0);
extern "C" __declspec( dllimport ) void SHAPI_Set36MHzDacs(int lingain, int loggain, int deviceNum=0);
extern "C" __declspec( dllimport ) void SHAPI_SetSA124Band23Xover(int myXover, int deviceNum=0);
extern "C" __declspec( dllimport ) void SHAPI_SetSA124ClockOut(int val, int deviceNum=0);

extern "C" __declspec( dllimport ) void SHAPI_PresetDevice(int deviceNum=0);

extern "C" __declspec( dllimport ) int SHAPI_Reset();
extern "C" __declspec( dllimport ) void SHAPI_SetLoopSleep(int val, int deviceNum=0);
extern "C" __declspec( dllimport ) int SHAPI_GetFastOneShot(double RFStartFreq, int numChunks, int * pIdata, int * pQdata, int deviceNum=0); // pwrdata has pdsize

extern "C" __declspec( dllimport ) int SHAPI_StoreToSA44Flash(LPCSTR tepfilename, LPCSTR binfilename, int deviceNum=0); // pwrdata has pdsize


